/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SerialPort {
    private static final String TAG = "SPort";
    protected FileDescriptor mFd;
    private FileInputStream mFileInputStream;
    private Context mContext;

    static {
        System.loadLibrary("gpequipment");
    }

    protected SerialPort(Context context) {
        this.mContext = context;
    }

    protected void openSerialPort(File device, int baudrate, int flags) throws IOException {
        if (!device.canRead() || !device.canWrite()) {
            try {
                Process su = Runtime.getRuntime().exec("/system/xbin/su");
                String cmd = "chmod 666 " + device.getAbsolutePath() + "\n" + "exit\n";
                su.getOutputStream().write(cmd.getBytes());
                if (su.waitFor() != 0 || !device.canRead() || !device.canWrite()) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
                    builder.setMessage((CharSequence)"\u6ca1\u6709\u6743\u9650");
                    builder.setPositiveButton((CharSequence)"\u5173\u95ed", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            ((Activity)SerialPort.this.mContext).finish();
                        }
                    });
                    builder.show();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.mFd = SerialPort.open(device.getAbsolutePath(), baudrate, flags);
        if (this.mFd == null) {
            Log.e((String)TAG, (String)"native open returns null");
            throw new IOException();
        }
        this.mFileInputStream = new FileInputStream(this.mFd);
    }

    protected InputStream getInputStream() {
        return this.mFileInputStream;
    }

    private static native FileDescriptor open(String var0, int var1, int var2);

    protected native void close();

    protected native void is();

    protected native boolean check(byte[] var1, int var2);

    protected native void update();

    protected native void updateCheck(byte[] var1, int var2);

    protected native void requestVersionInfo();

    protected native void requestUpdate(int var1, int var2, int var3, int var4);

    protected native void download(int var1, int var2, int var3, int var4, byte[] var5, int var6);
}

